/***************************************************************************
 *   Copyright (C) 2009 by Manuel Schrape                                  *
 *   manuel.schrape@gmx.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License.        *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DLG_MAP_H
#define DLG_MAP_H

#include <QDialog>
#include <QList>

#include "ui_dlg_Map.h"

#include "../Classes/cSettings.h"
#include "../qmapcontrol.h"
#include "../global.h"

using namespace qmapcontrol;

class dlg_Map :  public QDialog, public Ui::dlg_Map_UI
{
    Q_OBJECT

public:
    dlg_Map(QWidget *parent = 0);
    void add_Position(double x, double y);
    void create_Map(cSettings *t_Settings);

private:
    QPen* Pen[3];

    cSettings   *o_Settings;

    MapControl  *o_Map;
    MapAdapter  *o_Adapter;

    Layer       *o_Layer;
    Layer       *o_Click;
    Layer       *o_Route;

    QList<Point*> p_RouteWP;
    LineString*   l_RouteWP;

    QList<Point*> p_RouteFL;
    LineString*   l_RouteFL;

    Point* LastPos;
//    Point* LastPoint;
    Point* LastClick;

    Point   *ClickPoint;
    QPointF MapCenter;

    QList<sWayPoint> l_WayPoints;
    QList<sWayPoint> l_Track;

    QList<sWayPoint> parse_WayPointKML(QString s_File);
    QList<sWayPoint> parse_WayPointMKW(QString s_File);

    void show_WayPoints(QList<sWayPoint> WayPoints);

    void save_WayPointsMKW(QString s_File);

private slots:
    void slot_Zoom(int t_Zoom);
    void slot_ChangeMap(int);
    void slot_Click(const QMouseEvent*, const QPointF);

    void slot_AddWayPoint();
    void slot_DeleteWayPoints();
    void slot_SendWayPoints();
    void slot_ShowWayPoints(bool);

    void slot_LoadMapPic();

    void slot_GotoTarget();
    void slot_Close();

    void slot_LoadWayPoints();
    void slot_SaveWayPoints();

protected:
    virtual void resizeEvent ( QResizeEvent * event );

signals:
    void set_Target(sWayPoint Target);
    void set_WayPoints(QList<sWayPoint>);
    void set_Settings(cSettings *t_Settings);

};

#endif // DLG_MAP_H
